
# Mindbaz REST API – Postman Collection

This collection provides everything you need to work with the Mindbaz REST API using Postman.

---

## 📦 What's included

- `mindbaz-rest-api-collection-no-idsite-variable.json` – Full API collection
  - OAuth2 authentication requests (SSO + refresh token)
  - All API endpoints grouped by category
  - Authorization headers automatically configured with `Bearer {{access_token}}`
  - All necessary variables are defined in the collection (except site ID)

---

## 🚀 How to get started

### 1. Import the collection

1. Open Postman
2. Click on the "Collections" menu
3. Click **"Import"**
4. Choose the file: `mindbaz-rest-api-collection-no-idsite-variable.json`

---

### 2. Set your credentials

1. In the **Collections** tab, click on `Mindbaz API`
2. Open the **Variables** tab
3. Fill in:
   - `username` → your API login
   - `password` → your API password
   Make sure to fill in the credentials in both "initial Value" and "Current value" columns
4. Click **Save**

---

### 3. Authenticate

1. Open the request `SSO - Get Access Token`
2. Click **Send**
3. The `access_token` will be automatically stored and used for all API calls

---

### 4. Make your API calls

For each request that includes `:idsite` in the URL, you **must manually set the value** in the **Path Variables** section (Params tab in Postman).

Example:
- Request: `GET /api/:idsite/statistics/subscribers`
- In **Params > Path Variables**, set:
  - `idsite` = `YOUR SITE ID`

---

## 🔁 Token expired?

Use the `REFRESH TOKEN` request to generate a new access token using the stored `refresh_token`.

---

📘 Full API reference and usage:  
👉 https://learn.mindbaz.com/docs/
